/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.attn;

import com.ibm.hwmca.fw.attn.AttentionID;
import com.ibm.hwmca.fw.attn.np.AttentionCoreInfo;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Date;
import java.util.TimeZone;

public class Attention
implements Persistable {
    private static final String TRACE_MASKT = "XEMP000T";
    private static final String TRACE_MASKF = "XEMP000F";
    private static final String TRACE_MASKD = "XEMP000D";
    private AttentionCoreInfo coreInfo;
    private String persistenceKey = null;

    public Attention(ObjectId moID, LocalizableText text) {
        this(moID, text, new Date());
    }

    public Attention(ObjectId moID, LocalizableText text, Date date) {
        Trace.trace(TRACE_MASKT, ">> Attention()");
        if (moID != null && text != null && date != null) {
            ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
            ManagedObject mo = (ManagedObject)mom.get(moID);
            if (mo == null && !moID.equals(HMC.getHMC().getObjectId())) {
                throw new IllegalArgumentException("ManagedObject not found");
            }
        } else {
            throw new IllegalArgumentException("Illegal null value");
        }
        this.coreInfo = new AttentionCoreInfo(new AttentionID(), moID, date, text);
        this.coreInfo.setTimeZone(TimeZone.getDefault());
        Trace.trace(TRACE_MASKT, "<< Attention() : Attention = " + this);
    }

    protected Attention(PersistentData persistentData, String key) throws PersistenceException {
        Trace.trace(TRACE_MASKT, ">> Attention( PersistentData, String ) : Key = " + key);
        AttentionPersistentData data = (AttentionPersistentData)persistentData;
        if (data.version == 1L) {
            this.persistenceKey = key;
            this.coreInfo = data.attnID == null ? new AttentionCoreInfo(new AttentionID(), data.moID, data.date, data.text) : new AttentionCoreInfo(data.attnID, data.moID, data.date, data.text);
            if (data.zone == null) {
                this.coreInfo.setTimeZone(TimeZone.getDefault());
            } else {
                this.coreInfo.setTimeZone(data.zone);
            }
        } else {
            throw new PersistenceException("Incompatible versions");
        }
        Trace.trace(TRACE_MASKT, "<< Attention( PersistentData, String ) : Attention = " + this);
    }

    public final AttentionID getAttentionID() {
        return this.coreInfo.getAttentionID();
    }

    public final ObjectId getManagedObjectID() {
        return this.coreInfo.getManagedObjectID();
    }

    public final Date getCreationDate() {
        return this.coreInfo.getCreationDate();
    }

    public final void setCreationTimeZone(TimeZone timezone) {
        this.coreInfo.setTimeZone(timezone);
    }

    public final TimeZone getCreationTimeZone() {
        return this.coreInfo.getTimeZone();
    }

    public final LocalizableText getDescription() {
        return this.coreInfo.getDescription();
    }

    public final AttentionCoreInfo getCoreInfo() {
        return this.coreInfo;
    }

    public static final Attention getAttention(ObjectId moID, AttentionID attnID) {
        ManagedObject mo;
        Attention attn = null;
        if (moID != null && attnID != null && (mo = (ManagedObject)ManagedObjectManager.getManagedObjectManager().get(moID)) != null) {
            attn = mo.getAttention(attnID);
        }
        return attn;
    }

    public static final boolean deleteAttention(ObjectId moID, AttentionID attnID) {
        boolean result = false;
        if (moID != null && attnID != null) {
            Attention attn;
            ManagedObject mo = (ManagedObject)ManagedObjectManager.getManagedObjectManager().get(moID);
            if (mo != null && (attn = mo.getAttention(attnID)) != null) {
                mo.removeAttention(attn);
            }
        } else {
            throw new IllegalArgumentException("Illegal null value");
        }
        return result;
    }

    public String getAttentionDetailsClassName() {
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append("=[ManagedObject ID=");
        buffer.append(this.coreInfo.getManagedObjectID());
        buffer.append(",Attention ID=");
        buffer.append(this.coreInfo.getAttentionID());
        buffer.append(",Creation Date=");
        buffer.append(this.coreInfo.getCreationDate());
        buffer.append(",Description=");
        buffer.append(this.coreInfo.getDescription());
        buffer.append("]");
        return buffer.toString();
    }

    public PersistentData getPersistentData() {
        Trace.trace(TRACE_MASKT, ">> getPersistentData()");
        AttentionPersistentData data = new AttentionPersistentData();
        data.version = 1L;
        data.attnID = this.getAttentionID();
        data.moID = this.getManagedObjectID();
        data.date = this.getCreationDate();
        data.zone = this.getCreationTimeZone();
        data.text = this.getDescription();
        Trace.trace(TRACE_MASKT, "<< getPersistentData()");
        return data;
    }

    public boolean isUpgradeData() {
        return false;
    }

    public synchronized void persist() throws PersistenceException {
        Trace.trace(TRACE_MASKT, ">> persist()");
        PersistenceManager pm = PersistenceManager.getPersistenceManager();
        if (this.persistenceKey == null) {
            this.persistenceKey = pm.writeChild(HMC.getHMC().getPersistenceNameSpace(), this);
        } else {
            pm.write(this.persistenceKey, this);
        }
        Trace.trace(TRACE_MASKT, "<< persist()");
    }

    public synchronized void unpersist() throws PersistenceException {
        Trace.trace(TRACE_MASKT, ">> unpersist()");
        PersistenceManager pm = PersistenceManager.getPersistenceManager();
        if (this.persistenceKey != null) {
            pm.delete(this.persistenceKey);
        }
        Trace.trace(TRACE_MASKT, "<< unpersist()");
    }

    private static class AttentionPersistentData
    implements PersistentData {
        private static final long serialVersionUID = -1L;
        public static final long CURRENT_VERSION = 1L;
        public long version;
        public AttentionID attnID;
        public ObjectId moID;
        public Date date;
        public TimeZone zone;
        public LocalizableText text;

        private AttentionPersistentData() {
        }
    }
}

